﻿<%@ Page Title="Patients" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="PolyTraumaPatients.aspx.cs" Inherits="PolyTraumaPatients" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>
<%@ Register src="controls/ErrorList.ascx" tagname="ErrorList" tagprefix="uc1" %>
<%@ Register src="controls/Date.ascx" tagname="Date" tagprefix="uc2" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <style type="text/css">
        .style1
        {
            width: 100%;
        }
        .style2
        {
            width: 110px;
        }
        .style3
        {
        }
        .style4
        {
            width: 8px;
        }
        .style6
        {
            width: 110px;
        }
        .style8
        {
            width: 200px;
        }
        .style9
        {
            width: 100px;
        }
        .style10
        {
            width: 110px;
        }
        .style11
        {
            width: 250px;
        }
        .style12
        {
            width: 250px;
        }
        .style13
        {
            width: 200px;
        }
        .style14
        {
            width: 120px;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <asp:ValidationSummary ID="ValidationSummaryPolyTraumaPatients"  runat="server"
        TabIndex="1" 
        ValidationGroup="OnSave"
        HeaderText="The page has the following data errors:" 
        DisplayMode="BulletList" 
        ShowSummary="false" 
        ShowMessageBox="True" />
    <asp:ValidationSummary ID="ValidationSummaryOnSearch"  runat="server"
        TabIndex="2" 
        ValidationGroup="OnSearch"
        HeaderText="The page has the following data errors:" 
        DisplayMode="BulletList" 
        ShowSummary="false" 
        ShowMessageBox="True" />
    <div class = "excludeSaveWarnings">
    <asp:Panel ID="PanelObjectContent" runat="server">
        <br />
        <uc1:ErrorList ID="ErrorList1" runat="server" />
        <br />
        <asp:Panel ID="PanelSelectPatient" runat="server" GroupingText="Lookup Patient&nbsp;&nbsp;" Width="65%">
            <br />
            <asp:Label ID="LabelforTextBoxSSNSearch" runat="server" AssociatedControlID="TextBoxSSNSearch">SSN:</asp:Label>
                                
            <br />
            <asp:TextBox ID="TextBoxSSNSearch" runat="server"
                TabIndex="3" MaxLength = "12">
            </asp:TextBox>
            <asp:RegularExpressionValidator ID="RegularExpressionValidatorSSNSearch" runat="server" 
                TabIndex="4" 
                ControlToValidate="TextBoxSSNSearch" 
                Display="Dynamic" 
                ErrorMessage="SSN needs to be in the following format (dashes optional): XXX-XX-XXXX.  Include a 'P' or 'p' at the end for pseudo SSN’s."
                SetFocusOnError="true" 
                ValidationGroup="OnSearch"
                ValidationExpression="^\s*\d{3}-?\d{2}-?\d{4}[pP]?\s*$">
            </asp:RegularExpressionValidator>         
            <br /><br />
            <asp:Label ID="LabelforTextBoxPatientNameSearch" runat="server" AssociatedControlID="TextBoxPatientNameSearch">Patient Last Name:</asp:Label>
            <br />
            <asp:TextBox ID="TextBoxPatientNameSearch" runat="server" TabIndex="5"></asp:TextBox>
            <br /><br />
            
            <asp:Label ID="LabelForInjuryDateFrom" runat="server" 
                AssociatedControlID="InjuryDateFrom:TextBoxDate" Text="Injury Date From (mm/dd/yyyy):"></asp:Label>
            <br />
            <uc2:Date ID="InjuryDateFrom" runat="server" ValidationGroup="OnSearch" CustomValidatorValidationGroup="OnSearch" 
                ErrorMessage="Injury Date From must be in format (mm/dd/yyyy)." />
            <br />
            <asp:Label ID="LabelForInjuryDateTo" runat="server" 
                AssociatedControlID="InjuryDateTo:TextBoxDate" Text="Injury Date To (mm/dd/yyyy):"></asp:Label>
            <br />
            <uc2:Date ID="InjuryDateTo" runat="server" ValidationGroup="OnSearch" CustomValidatorValidationGroup="OnSearch"
                ErrorMessage="Injury Date To must be in format (mm/dd/yyyy)." />
                
            <asp:CompareValidator ID = "InjuryDateValidator" runat = "server" EnableClientScript = "true" 
                 ControlToValidate = "InjuryDateTo:TextBoxDate" ControlToCompare = "InjuryDateFrom:TextBoxDate"
                 ValidationGroup="OnSearch" Type = "Date" Operator = "GreaterThanEqual" 
                 ErrorMessage = "Injury Date To must be later than or equal to Injury Date From"></asp:CompareValidator>
            <br />
            <asp:Label ID="LabelVisn" runat="server" Text="VISN:" Font-Bold="true" AssociatedControlID="DropDownListVISN"></asp:Label>
            <br />
            <asp:DropDownList ID="DropDownListVISN" runat="server"
                DataSourceID="ObjectDataSourcePolyTraumaVAMC" 
                DataTextField="Name" 
                DataValueField="institution_id"
                AppendDataBoundItems="true">
                <asp:ListItem Value="0">-- Select a Value --</asp:ListItem>
            </asp:DropDownList>
            <br />
            <br />
            <asp:Button ID="ButtonSearchPatient" runat="server" 
                TabIndex="6" 
                Text="  Search  " 
                ValidationGroup="OnSearch"
                onclick="ButtonSearchPatient_Click" />
            <br /><br />
            
            <asp:ObjectDataSource ID="ObjectDataSourcePolyTraumaVAMC" runat="server" 
                SelectMethod="GetPolyTraumaVAMCList" 
                TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
            </asp:ObjectDataSource>
            
            <asp:GridView ID="GridViewPatients" runat="server" Visible="False"
            DataKeyNames="PATIENT_ID"
            AutoGenerateColumns="False" Width="100%"
            DataSourceID="ObjectDataSourceCriteriaSearch"
            AllowPaging="True" AllowSorting="True">
            <Columns>
                
                <asp:HyperLinkField DataNavigateUrlFields="TBI_POLYTRAUMA_ID" SortExpression="TBI_POLYTRAUMA_ID" NavigateUrl="~/PolyTraumaEntry.aspx"
                            ItemStyle-HorizontalAlign="Center" HeaderStyle-HorizontalAlign="Center"
                            DataNavigateUrlFormatString="PolyTraumaEntry.aspx?id={0}"
                            Text=" View " ShowHeader="false">
                            <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center" Width="18px"></ItemStyle>
                </asp:HyperLinkField>

                <asp:BoundField DataField="Snum" HeaderText="SSN" 
                    SortExpression="Snum" >
                    <ItemStyle HorizontalAlign="Center" />
                </asp:BoundField>

                <asp:TemplateField HeaderText="Patient Name" SortExpression="LAST_NAME">
                    <ItemStyle HorizontalAlign="Left" />
                    <ItemTemplate>
                        <asp:Label ID="LabelLastName" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("LAST_NAME")))%>'></asp:Label>
                        ,&nbsp;<asp:Label ID="LabelFirstName" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("FIRST_NAME")))%>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>

                <asp:TemplateField HeaderText="Polytrauma Center" SortExpression="STD_INSTITUTION1.VISN_ID">
                    <ItemStyle HorizontalAlign="Left" />
                    <ItemTemplate>
                        (<asp:Label ID="LabelPolyTraumaCenterVisn" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION1.STD_INSTITUTION_PARENT.NAME")))%>'></asp:Label>)
                        (<asp:Label ID="LabelPolyTraumaCenterStationNumber" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION1.STATIONNUMBER")))%>'></asp:Label>)
                        <asp:Label ID="LabelPolyTraumaCenterVistaName" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION1.VISTANAME")))%>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                
                <asp:TemplateField HeaderText="Injury Date" SortExpression="TBI_INJURY_DATE">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelInjuryDate" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("TBI_INJURY_DATE","{0:d}"))) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                
                <asp:TemplateField HeaderText="Admission Date" SortExpression="REHAB_ADMIT_DATE">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelAdmissionDate" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("REHAB_ADMIT_DATE","{0:d}"))) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>


            </Columns>
            </asp:GridView>
            <br />
            <asp:ObjectDataSource ID="ObjectDataSourceCriteriaSearch" runat="server" 
                SelectMethod="SelectCriteriaSearch" 
                SelectCountMethod="SelectCriteriaSearchCount" 
                StartRowIndexParameterName="startRow" 
                MaximumRowsParameterName="maxRows" 
                SortParameterName="sort"
                EnablePaging="True"   
                TypeName="VeteransAffairs.Registries.BusinessManager.TBI.PolyTraumaPatientManager"
                DataObjectTypeName="VeteransAffairs.Registries.Business.TBI.TBI_POLYTRAUMA">
                <SelectParameters>
                    <asp:ControlParameter ControlID="TextBoxPatientNameSearch" 
                         Direction="Input" Name="lastName" Type="String"/>
                    <asp:ControlParameter ControlID="TextBoxSSNSearch" 
                         Direction="Input" Name="snum" Type="String"/>
                    <asp:ControlParameter Type = "String" ControlID = "InjuryDateFrom"
                         Direction = "Input" Name = "fromDate" PropertyName = "DateValue" />
                    <asp:ControlParameter Type = "String" ControlID = "InjuryDateTo"
                         Direction = "Input" Name = "toDate" PropertyName = "DateValue" />
                    <asp:ControlParameter Type = "String" ControlID = "DropDownListVISN" Direction = "Input"
                        PropertyName = "SelectedValue" Name = "visn" />
                    <asp:Parameter Name="sort" Type="String" />
                    <asp:Parameter Name="startRow" Type="Int32" />
                    <asp:Parameter Name="maxRows" Type="Int32" />
                </SelectParameters>
            </asp:ObjectDataSource>
        </asp:Panel>
    </asp:Panel>
    </div> 
    <asp:Panel ID="PanelNoAccess" runat="server" Visible="false" Width="65%">
            You do not have access to the patient id supplied.
            <br /><br />
            Please contact the Registry Manager to grant access or verify that your permissions are correct.
    </asp:Panel>
    <asp:Panel ID="PanelNoInsertAllowed" runat="server" Visible="false" Width="65%">
            You do not have permission to enter a new patient.
            <br /><br />
            Please contact the Registry Manager to grant access or verify that your permissions are correct.
    </asp:Panel>
    <asp:Panel ID="PanelIdNotFound" runat="server" Visible="false" Width="65%">
            No record found for the patient ID supplied.
            <br />
            <br />
            If you tried accessing using a link within an email or typed the link in the browser, please check the link to ensure you have supplied a correct id.
    </asp:Panel>       
    <asp:HiddenField ID="HiddenFieldEntryID" runat="server"/>
</asp:Content>



